/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager.Admin;

import ibm.nways.analysis.dpCommon.ResourceDefinition;
import ibm.nways.analysis.dpCommon.SortedStringVector;
import ibm.nways.analysis.dpManager.Admin.BasicConfigPanel;
import ibm.nways.analysis.dpManager.Admin.DpAdminPanel;
import ibm.nways.analysis.dpManager.Admin.IdSelector;
import ibm.nways.analysis.dpManager.VectorUtil;
import ibm.nways.jdm.eui.ColumnLayout;
import ibm.nways.nhm.eui.AccumulatorBox;
import java.applet.Applet;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;

public class Templates
extends BasicConfigPanel
implements ItemListener,
JCItemListener {
    private static ResourceBundle adminRB = ResourceBundle.getBundle("ibm.nways.analysis.dpManager.Admin.AdminResources");
    private static final String ADD_BUTTON_LABEL = adminRB.getString("s_Add");
    private static final String EDIT_BUTTON_LABEL = adminRB.getString("s_Edit");
    private static final String REMOVE_BUTTON_LABEL = adminRB.getString("s_Remove");
    private static final String NEW_BUTTON_LABEL = adminRB.getString("s_New");
    private static final String LOADED_POD_NAMES = adminRB.getString("s_LoadedPODNames");
    private static final String APPLIED_POD_NAMES = adminRB.getString("s_AppliedPODNames");
    private static final String LOADED_VIEW_NAMES = adminRB.getString("s_LoadedViewNames");
    private static final String APPLIED_VIEW_NAMES = adminRB.getString("s_AppliedViewNames");
    private DpAdminPanel adminPanel;
    private AccumulatorBox podBox;
    private AccumulatorBox viewBox;
    private SortedStringVector podAssociated;
    private SortedStringVector viewAssociated;
    private IdSelector resourceID;

    public Templates(DpAdminPanel dpAdminPanel, Applet applet) {
        super(applet);
        this.adminPanel = dpAdminPanel;
        this.resourceID = new IdSelector(adminRB.getString("s_ResourceIdentifier"), false);
        this.add("North", this.resourceID);
        this.resourceID.addItemListener(this);
        Panel panel = new Panel(new ColumnLayout(1));
        this.podBox = new AccumulatorBox(new Vector(), new Vector(), 5, LOADED_POD_NAMES, APPLIED_POD_NAMES, ADD_BUTTON_LABEL, REMOVE_BUTTON_LABEL, EDIT_BUTTON_LABEL, 200, 125);
        this.podBox.addItemListener(this);
        this.viewBox = new AccumulatorBox(new Vector(), new Vector(), 5, LOADED_VIEW_NAMES, APPLIED_VIEW_NAMES, ADD_BUTTON_LABEL, REMOVE_BUTTON_LABEL, EDIT_BUTTON_LABEL, 200, 125);
        this.viewBox.addItemListener(this);
        panel.add(this.podBox);
        panel.add(this.viewBox);
        this.add("Center", panel);
    }

    protected void populate() {
        String string = null;
        if (this.resourceID.getSelectedItem() != null) {
            string = this.resourceID.getSelectedItem();
        }
        Vector vector = null;
        try {
            vector = this.adminPanel.getClientApplet().getResourceDefinitionList();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        this.resourceID.removeAllIds();
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.resourceID.addId((String)enumeration.nextElement());
            }
            if (this.resourceID.getItemCount() > 0) {
                if (string == null || string.length() == 0) {
                    string = this.resourceID.getItem(0);
                }
                this.selectItem(string);
            }
        }
    }

    protected void save() {
        if (this.isDirty()) {
            Vector vector = VectorUtil.stringsToVector(this.podBox.getRightListItems());
            Vector vector2 = VectorUtil.findAdditions(this.podAssociated, vector);
            Vector vector3 = VectorUtil.findDeletions(this.podAssociated, vector);
            this.podAssociated = new SortedStringVector(vector);
            Vector vector4 = VectorUtil.stringsToVector(this.viewBox.getRightListItems());
            Vector vector5 = VectorUtil.findAdditions(this.viewAssociated, vector4);
            Vector vector6 = VectorUtil.findDeletions(this.viewAssociated, vector4);
            this.viewAssociated = new SortedStringVector(vector4);
            try {
                if (vector2 != null || vector5 != null) {
                    this.adminPanel.getClientApplet().addTemplateDefinitionsToResource(vector2, vector5, "ALL", this.resourceID.getSelectedItem());
                    System.out.println("POD and/or View added: ");
                }
                if (vector3 != null || vector6 != null) {
                    this.adminPanel.getClientApplet().removeTemplateDefinitionsFromResource(vector3, vector6, "ALL", this.resourceID.getSelectedItem());
                    System.out.println("POD and/or View deleted: ");
                }
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            this.setDirty(false);
        }
    }

    protected void cancel() {
        this.displayTemplatesInfo(this.resourceID.getSelectedItem());
        this.setDirty(false);
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
        if (jCItemEvent.getSource() == this.podBox) {
            if (jCItemEvent.getStateChange() == 1) {
                this.adminPanel.setPage(adminRB.getString("s_PODConfig"));
                this.adminPanel.getDpePollDefs().selectItem(jCItemEvent.getItem().toString());
                return;
            }
            if ((jCItemEvent.getStateChange() & 0xC00) != 0) {
                this.setDirty(true);
                return;
            }
        } else if (jCItemEvent.getSource() == this.viewBox) {
            if (jCItemEvent.getStateChange() == 1) {
                this.adminPanel.setPage(adminRB.getString("s_ViewCfg"));
                this.adminPanel.getViews().selectItem(jCItemEvent.getItem().toString());
                return;
            }
            if ((jCItemEvent.getStateChange() & 0xC00) != 0) {
                this.setDirty(true);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.resourceID) {
            this.displayTemplatesInfo((String)itemEvent.getItem());
        }
    }

    public void selectItem(String string) {
        this.resourceID.select(string);
        this.displayTemplatesInfo(string);
    }

    protected void displayTemplatesInfo(String string) {
        ResourceDefinition resourceDefinition = null;
        Vector vector = null;
        Vector vector2 = null;
        try {
            vector = this.adminPanel.getClientApplet().getPollingObjectDefinitionList();
            resourceDefinition = this.adminPanel.getClientApplet().getResourceDefinition(string);
            vector2 = this.adminPanel.getClientApplet().getViewNamesList();
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        Vector vector3 = null;
        this.podAssociated = null;
        Vector vector4 = null;
        this.viewAssociated = null;
        if (resourceDefinition != null) {
            vector3 = VectorUtil.diffOfTwoVectors(vector, resourceDefinition.getDefinitionVector());
            this.podAssociated = new SortedStringVector(resourceDefinition.getDefinitionVector());
            vector4 = VectorUtil.diffOfTwoVectors(vector2, resourceDefinition.getViewsVector());
            this.viewAssociated = new SortedStringVector(resourceDefinition.getViewsVector());
        } else {
            vector3 = vector;
            this.podAssociated = null;
            vector4 = vector2;
            this.viewAssociated = null;
        }
        this.podBox.setLeftList(vector3);
        this.podBox.setRightList(this.podAssociated);
        this.viewBox.setLeftList(vector4);
        this.viewBox.setRightList(this.viewAssociated);
        this.podBox.reset();
        this.viewBox.reset();
        this.setDirty(false);
    }
}

